function IntegralValuePositioner(){

	this.initialize.apply(this, arguments);
}
IntegralValuePositioner.prototype = {

	initialize: function(){
	},
	roundPositionOfLayersFirstFrameElements: function(timeline){

		var layers = timeline.layers;
		this.roundPositionOfLayersFrameElements(layers, 0);
	},
	roundPositionOfLayersCurrentFrameElements: function(timeline){

		var currentFrame = timeline.currentFrame;
		var layers = timeline.layers;
		this.roundPositionOfLayersFrameElements(layers, currentFrame);
	},
	roundPositionOfSelectedLayerFramesElements: function(timeline){

		var selectedLayerIds = timeline.getSelectedLayers();
		if(selectedLayerIds.length != 1) return false;

		this.roundPositionOfLayerFramesElements(
			timeline.layers[selectedLayerIds[0]]
		);
		return true;
	},
	roundPositionOfLayersFrameElements: function(layers, frame){

		var layerTotal = layers.length;
		for(var i = 0; i < layerTotal; i++)
			this.roundPositionOfLayerFrameElements(layers[i], frame);
	},
	roundPositionOfLayerFramesElements: function(layer){

		var frameTotal = layer.frames.length;
		for(var i=0; i < frameTotal; i++)
			this.roundPositionOfLayerFrameElements(layer, i);
	},
	roundPositionOfLayerFrameElements: function(layer, frameNum){

		this.roundPositionOfElements(layer.frames[frameNum].elements);	
	},
	roundPositionOfElements: function(elements){

		var elementTotal = elements.length;
		for(var i = 0; i < elementTotal; i++)
			this.roundPosition(elements[i]);
	},
	roundPosition: function(element){

		element.x = Math.round(element.x);
		element.y = Math.round(element.y);
	}
};

