package com.dango_itimi.geom.core {
	
	import flash.geom.Point;

	/**
	 * 
	 */
	public class Polygons {

		public static function createEllipse(
			drawedFirstX:Number,	
			drawedFirstY:Number,	
			maxRadiusX:Number,
			maxRadiusY:Number,
			vertexTotal:uint
		):Vector.<flash.geom.Point>{
			
			var vertexMax:uint = vertexTotal + 1;
			var vertices:Vector.<flash.geom.Point> = new Vector.<flash.geom.Point>(vertexMax, true);
			
			for (var i:int = 0; i < vertexMax; i++) {
				
				var rad:Number = (i / (vertexTotal / 2)) * Math.PI;
				var x:Number = maxRadiusX * Math.sin(rad) + drawedFirstX;
				var y:Number = maxRadiusY * Math.cos(rad) + drawedFirstY;
				vertices[i] = new flash.geom.Point(x, y);
			}
			return vertices;
		}
	}
}
