package com.dango_itimi.googlemap {
	
	import com.google.maps.overlays.Polyline;
	import com.google.maps.Map;
	import com.google.maps.LatLng;
	import com.dango_itimi.geom.core.Polygons;
	import flash.geom.Point;

	/**
	 * 参考
	 * http://www.nanchatte.com/map/circle.html
	 */
	public class Circle {
		
		//赤道半径 (WGS-84) 
		private static var EQUATORIAL_RADIUS:Number = 6378137; 
		
		//扁平率の逆数 (WGS-84)
		private static var F:Number = 298.257223563;
		
		//離心率の２乗
		private static var E:Number;
		
		//π × 赤道半径	
		private static var PI_ER:Number;
		
		private static var TMP_LAT:Number;
		private static var TMP_LNG:Number;

		{
			E = ((2 * F) -1) / Math.pow(F, 2);	
			PI_ER = Math.PI * EQUATORIAL_RADIUS;
			TMP_LAT = PI_ER * (1 - E) / 180;
			TMP_LNG = PI_ER / 180;
		}

		public static function create(center:LatLng, vertexTotal:uint, meterRadius:Number):Circle {
			
			var TMP:Number = 1 - E * Math.pow(Math.sin(center.latRadians()), 2);
			var arc_lat:Number = TMP_LAT / Math.pow(TMP, 3/2);
			var arc_lng:Number = TMP_LNG * Math.cos(center.latRadians()) / Math.pow(TMP, 1/2);
			
			var vertices:Vector.<Point> = Polygons.createEllipse(
				center.lat(),
				center.lng(), 
				meterRadius / arc_lat,
				meterRadius / arc_lng,
				vertexTotal
			);
			return new Circle(vertices);
		}
		private var vertices:Vector.<Point>;
		private var latLngs:Array;
		
		public function Circle(vertices:Vector.<Point>) {
			
			this.vertices = vertices;
			latLngs = convertLatLng(vertices);
		}
		private static function convertLatLng(vertices:Vector.<Point>):Array {
			
			var latLngs:Array = new Array(vertices.length);
			for (var i:Number = 0; i < latLngs.length; i++) {
				
				var point:Point = vertices[i];
				latLngs[i] = new LatLng(point.x, point.y);
			}
			return latLngs;
		}
		public static function draw(map:Map, circleData:Circle):void {
			
			var line:Polyline = new Polyline(circleData.latLngs);
			map.addOverlay(line);
		}
	}
}
