function Edginger(){

	this.initialize.apply(this, arguments);
}

/**
 * -100 <= edging <= 100
 * cut >= 1
 */
Edginger.prototype.initialize = function(edging, cut){

	this.edging = edging;
	this.cut = cut;
};

/**
 * distance != 0
 */
Edginger.prototype.getDistances = function(distance){
	
	var vec = 1;
	if(distance < 0){
		distance *= -1;
		vec = -1;
	}

	var distances = new Array(this.cut);
	var bpt = 0;
	for (var i = 0; i < this.cut; i++) {
		
		var c = (i+1) / this.cut;
		var pt = distance * (c + this.edging / (100 * Math.PI) * Math.sin(Math.PI * c));	
		distances[i] = (pt - bpt) * vec;
		bpt = pt;
	}
	return distances;
};

/**
 * points.length == cut + 1
 * points[0] == firstPt
 */
Edginger.prototype.getPoints = function(firstPt, endPt){
	
	var points = new Array();
	var p = endPt - firstPt;
	for (var i = 0; i < this.cut; i++) {
		
		var c = (i+1) / this.cut;
		points[i] = p * (c + this.edging / (100 * Math.PI) * Math.sin(Math.PI * c)) + firstPt;	
	}
	points.unshift(firstPt);
	return points;
};

