function Linkager(){

	this.initialize.apply(this, arguments);
}
Linkager.prototype.initialize = function(){

	fl.trace("---");
	var library = fl.getDocumentDOM().library;
	var items = library.getSelectedItems();
	var itemsLength = items.length;

	if(itemsLength == 0){
		fl.trace("CuACeIĂ");
		return;
	}

	for(var i = 0; i < itemsLength; i++){

		var item = items[i];
		if(item.itemType == "folder") continue;

		var pathNames = item.name.split("/");

		var symbolName = pathNames[pathNames.length - 1];
		var classNames = symbolName.split("_");

		var baseClassPath = "";
		if(classNames.length == 2){

			pathNames[pathNames.length - 1] = classNames[0];

			var basePathNames = pathNames.concat();
			basePathNames[basePathNames.length - 1] = classNames[1];
			baseClassPath = basePathNames.join(".");
		}
		
		var linkageIdentifier = pathNames.join(".");

		item.linkageExportForAS = true;
		item.linkageExportInFirstFrame = true;
		item.linkageIdentifier = linkageIdentifier;
		item.linkageBaseClass = baseClassPath;

		fl.trace(item.linkageIdentifier);
		if(baseClassPath != "")
			fl.trace("@" + item.linkageBaseClass);
		
	}
};

var linkager = new Linkager();
