package;

import createjs.easeljs.Stage;
import createjs.easeljs.Shape;
import createjs.easeljs.Ticker;
import createjs.easeljs.Container;
import createjs.soundjs.SoundJS;
import js.Lib;
import loader.TemplateHtmlLoader;
import loader.MaterialLoader;
import parser.TemplateHtmlParser;
import lib.net.Loader;

class Main {
	
	private var mainFunction:Dynamic;
	private var stage:Stage;
	private var shootingplayerView:Container;
	private var templateHtmlLoader:TemplateHtmlLoader;
	private var templateHtmlParser:TemplateHtmlParser;
	private var materialLoader:MaterialLoader;
	
	public static function main() {
		new Main();
	}
	public function new(){
		
		Lib.window.onload = initialize;
	}
	private function initialize(event){

		Ticker.useRAF = true;		
		Ticker.setFPS(24);
		Ticker.addListener(run);
		
		stage = new Stage(cast js.Lib.document.getElementById("canvas"));
		
		initializeToLoadTemplateHtml();
	}
	private function run(){
		
		mainFunction();
	}
	private function initializeToLoadTemplateHtml(){
		
		templateHtmlLoader = new TemplateHtmlLoader();
		templateHtmlLoader.load();
		mainFunction = loadTemplateHtml;
	}
	private function loadTemplateHtml(){
		
		templateHtmlLoader.run();
		if(templateHtmlLoader.isFinished())
			parseTemplateHtml();
	}
	private function parseTemplateHtml(){
		
		var loader = templateHtmlLoader.getLoader();
		
		var manifestForView = TemplateHtmlParser.execute(
			loader.getResult(URI.MATERIAL_VIEW_TMPL_HTML).result,
			URI.MATERIAL_VIEW_DIRECTORY
		);
		var manifestForSound = TemplateHtmlParser.execute(
			loader.getResult(URI.MATERIAL_SOUND_TMPL_HTML).result,
			URI.MATERIAL_SOUND_DIRECTORY
		);
		
		initializeToLoadMaterial(
			manifestForView.concat(manifestForSound)
		);
	}
	private function initializeToLoadMaterial(manifest:Array<Dynamic>){
		
		materialLoader = new MaterialLoader(manifest);
		materialLoader.load();
		mainFunction = loadMaterial;
	}
	private function loadMaterial(){
		
		materialLoader.run();
		if(materialLoader.isFinished())
			mainFunction = initializeToPlay;
	}
	private function initializeToPlay(){
		
		shootingplayerView = Lib.eval("new window.lib.shootingplayerView()");
		shootingplayerView.setTransform(70,212,1,1,0,0,0,18,17);
		stage.addChild(shootingplayerView);	
		
		SoundJS.setMasterVolume(0.2);
		SoundJS.play("shootingseExplosion", SoundJS.INTERRUPT_EARLY, 0, 0, 0);
		
		mainFunction = play;
	}
	private function play(){
		
		shootingplayerView.x += 1;
		stage.update();
	}
}

