package lib.net;

import createjs.preloadjs.PreloadJS;

class Loader {
	
	private var loader:PreloadJS;

	public function new(?useXHR:Bool = false, ?plugin:Dynamic = null){
		
		initialize(useXHR, plugin);
	}
	public function initialize(?useXHR:Bool = false, ?plugin:Dynamic = null){
		
		loader = new PreloadJS();
		loader.initialize(useXHR);
		loader.onFileLoad = onFileLoad;
		loader.onFileError = onFileError;
		loader.onComplete = onComplete;
		
		if(plugin != null) loader.installPlugin(plugin);
	}
	public function loadFile(url:String){
		
		loader.loadFile(url);
	}
	public function loadManifest(manifest:Array<Dynamic>){
		
		loader.loadManifest(manifest);
	}
	private function onFileLoad(event){
		
		//trace(event);
	}
	private function onFileError(event){
		
		trace("error", event);
	}
	private function onComplete(event){
	}
	public function isFinished():Bool{
		
		return loader.loaded;
	}
	public function getResult(id:String):Dynamic{
		
		return loader.getResult(id);
	}
}
