package loader;

import lib.net.Loader;
import lib.net.manifest.ManifestItemSet;

class TemplateHtmlLoader {
	
	private var loader:Loader;
	private var manifestItemSet:ManifestItemSet;
	private var mainFunction:Dynamic;

	public function new(){
		
		manifestItemSet = new ManifestItemSet();
		manifestItemSet.add(URI.MATERIAL_VIEW_TMPL_HTML);
		manifestItemSet.add(URI.MATERIAL_SOUND_TMPL_HTML);
		
		loader = new Loader();
	}
	public function run(){
		
		mainFunction();
	}
	public function load(){
		
		loader.loadManifest(manifestItemSet.createManifest());
		mainFunction = waitToFinishLoaded;
	}
	private function waitToFinishLoaded(){

		if(loader.isFinished())
			mainFunction = finish;
	}
	private function finish(){
	}	
	public function isFinished():Bool{

		return Reflect.compareMethods(mainFunction, finish);
	}
	
	public function getLoader(){
		
		return loader;
	}
	
}
