package;

import createjs.easeljs.Stage;
import createjs.easeljs.Shape;
import createjs.easeljs.Ticker;
import createjs.easeljs.Container;
import createjs.soundjs.SoundJS;
import js.Lib;
import lib.toolkit_for_createjs.Preloader;

class Main {
	
	private var mainFunction:Dynamic;
	private var stage:Stage;
	private var shootingplayerView:Container;
	private var preloader:Preloader;
	
	public static function main() {
		new Main();
	}
	public function new(){
		
		Lib.window.onload = initialize;
	}
	private function initialize(event){

		Ticker.useRAF = true;		
		Ticker.setFPS(24);
		Ticker.addListener(run);
		
		stage = new Stage(cast js.Lib.document.getElementById("canvas"));
		
		initializeToPreload();
	}
	private function run(){
		
		mainFunction();
	}
	private function initializeToPreload(){
		
		preloader = new Preloader("createjs", "createjs_sounds", true);
		//preloader = new Preloader("createjs", "createjs_sounds");
		//preloader = new Preloader("createjs");
		//preloader = new Preloader("createjs", "", true);
		
		preloader.addMaterialDirectory("view");
		preloader.addMaterialDirectory("sound");
		
		mainFunction = preload;
	}
	private function preload(){
		
		preloader.run();
		if(preloader.isFinished())
			mainFunction = initializeToPlay;
	}
	private function initializeToPlay(){
		
		shootingplayerView = Lib.eval("new window.lib.shootingplayerView()");
		shootingplayerView.setTransform(70,212,1,1,0,0,0,18,17);
		stage.addChild(shootingplayerView);	
		
		SoundJS.play("shootingseExplosion", SoundJS.INTERRUPT_EARLY, 0, 0, 0);
		
		mainFunction = play;
	}
	private function play(){
		
		shootingplayerView.x += 1;
		stage.update();
	}
}

