package lib.toolkit_for_createjs.loader;

import lib.net.LoaderWithPreloadJS;
import js.Lib;
import createjs.soundjs.SoundJS;

class MaterialLoader{

	private var images:Dynamic;
	private var loader:LoaderWithPreloadJS;
	private var mainFunction:Dynamic;
	private var manifest:Array<Dynamic>;
	
	public function new(manifest:Array<Dynamic>){
		
		this.manifest = manifest;	
		
		images = Lib.eval("window.images||{}");
		loader = new LoaderWithPreloadJS(false, SoundJS);
	}
	public function run(){
		
		mainFunction();
	}
	public function load(){
		
		loader.loadManifest(manifest);
		mainFunction = waitToFinishLoaded;
	}
	private function waitToFinishLoaded(){

		if(loader.isFinished())
			setImages();
	}
	private function setImages(){
		
		for(i in 0...manifest.length){
			
			var result = loader.getResult(manifest[i].src);
			if(result != null && result.type == "image"){
				images[result.id] = result.result;
			}
		}
		mainFunction = finish;
	}
	private function finish(){
	}	
	public function isFinished():Bool{

		return Reflect.compareMethods(mainFunction, finish);
	}
}
