package lib.toolkit_for_createjs.loader;

import lib.net.LoaderWithPreloadJS;
import lib.net.manifest.ManifestItemSet;
import lib.toolkit_for_createjs.MaterialURI;

class TemplateHtmlLoader {
	
	private var loader:LoaderWithPreloadJS;
	private var manifestItemSet:ManifestItemSet;
	private var mainFunction:Dynamic;

	public function new(materialDirectorySet:Array<String>){
		
		manifestItemSet = new ManifestItemSet();
		
		for(i in 0...materialDirectorySet.length){
			manifestItemSet.add(
				MaterialURI.getTemplateHtmlUri(materialDirectorySet[i])
			);
		}
		
		loader = new LoaderWithPreloadJS();
	}
	public function run(){
		
		mainFunction();
	}
	public function load(){
		
		loader.loadManifest(manifestItemSet.createManifest());
		mainFunction = waitToFinishLoaded;
	}
	private function waitToFinishLoaded(){

		if(loader.isFinished())
			mainFunction = finish;
	}
	private function finish(){
	}	
	public function isFinished():Bool{

		return Reflect.compareMethods(mainFunction, finish);
	}
	
	public function getLoader(){
		
		return loader;
	}
	
}
