﻿import game.automap.TipList;
import game.automap.RectList;

/**
 * ローグライクマップ自動生成
 * 
 * @author dango-itimi
 */
class game.automap.AutoMap {
	
	private var tipList :TipList;
	private var rectList:RectList;
	
	//Mapサイズ
	public static var MX:Number = 30;
	public static var MY:Number = 30;
	public static var RS:Number = 3;
	
	//Singleton
	private static var instance:AutoMap = new AutoMap();
	public  static function get _instance():AutoMap{ return instance; }
	private function AutoMap(){}
	
	/**
	 * 初期化
	 * 
	 * @param mx マップXサイズ
	 * @param my マップYサイズ
	 * @param rs 部屋最小サイズ
	 */
	public function init(mx:Number, my:Number, rs:Number):Void{
		
		if(mx != undefined ) AutoMap.MX = mx;
		if(my != undefined ) AutoMap.MY = my;
		if(rs != undefined ) AutoMap.RS = rs;

		tipList  = TipList._instance;
		rectList = RectList._instance;
		tipList.init();
		rectList.init();

		rectList.create();  //マップ区画分け & 部屋作成
		rectList.setPass(); //通路作成
	}
	
	/**
	 * マップtrace
	 */
	public function traceMap():Void{ tipList.traceMap(); }
}
