﻿import game.automap.TipList;
import game.automap.Position;
import game.automap.Tip;

/**
 * 分割線
 * 
 * @author dango-itimi
 */
class game.automap.Couple {

	private var tipList:TipList;
	
	private var pos1:Position; //始点
	private var pos2:Position; //終点

	private var npos1:Position = null; //必須接続位置1
	private var npos2:Position = null; //必須接続位置2

	//縦通路か横通路か
	public static var KIND_COLS:Number = 1; //縦
	public static var KIND_ROWS:Number = 2; //横
	private var kind:Number;
	
	//getter
	public function get _pos1():Position{ return this.pos1; }
	public function get _pos2():Position{ return this.pos2; }
	public function get _kind():Number  { return this.kind; }

	/**
	 * コンストラクタ
	 */
	public function Couple( pos1:Position, pos2:Position ){

		this.pos1 = pos1;
		this.pos2 = pos2;

		//通路種別判定
		this.kind = (pos1._x == pos2._x) ? KIND_COLS : KIND_ROWS;

		this.tipList = TipList._instance;
		
		testTrace(); //test
	}
	
	/**
	 * TEST 区切り線trace表示用
	 */
	private function testTrace():Void{
		
		//暫定 : 区切り線trace用
		if( kind == KIND_COLS ){
			
			for( var y:Number=pos1._y; y < pos2._y ; y++ )
				tipList.setPosKind( new Position(pos1._x, y), -1 );
		}else{
			
			for( var x:Number=pos1._x; x < pos2._x ; x++ )
				tipList.setPosKind( new Position(x, pos1._y), -1 );
		}
	}

	/**
	 * 必須通路作成処理
	 *
	 * @param pos この分割線に通路を繋げる位置
	 */
	public function setPass( pos:Position ):Void{
		
		//分割線が縦の場合 : 横方向に通路を接続
		var cpl:Couple;
		var tp :Position;
		if( kind == KIND_COLS ){
			
			//通路を繋げる位置から分割線までの交差点の割り出し
			tp = new Position(pos1._x, pos._y);
			
			cpl = getTmpCouple(pos, tp, pos._x, tp._x);
			cpl.linePassX();

		//分割線が横の場合 : 縦方向に通路を接続
		}else{
			//通路を繋げる位置から分割線までの交差点の割り出し
			tp = new Position(pos._x, pos1._y);
			
			cpl = getTmpCouple(pos, tp, pos._y, tp._y);
			cpl.linePassY();
		}
		//部屋からの通路がこの分割線に二本接続された場合 : その二本を接続
		if( recordPassPos(tp) ) setNeedPass();
	}

	/**
	 * 必須接続位置から通路作成
	 */
	private function setNeedPass():Void{

		var cpl:Couple;
		if( kind == KIND_COLS ){
			cpl = getTmpCouple(npos1, npos2, npos1._y, npos2._y);
			cpl.linePassY();

		}else{
			cpl = getTmpCouple(npos1, npos2, npos1._x, npos2._x);
			cpl.linePassX();
		}
	}

	/**
	 * 二点位置から暫定分割線作成
	 * 座標の小さいほうを始点とする
	 *
	 * @param n1 p1の調査座標
	 * @param n2 p2の調査座標
	 */
	private function getTmpCouple(
		p1:Position, p2:Position, n1:Number, n2:Number):Couple{
			
		return (n2 - n1 > 0) ? new Couple(p1, p2) : new Couple(p2, p1);
	}

	/**
	 * 始点と終点を繋げる X方向
	 */
	private function linePassX():Void{

		for( var x:Number=pos1._x ; x <= pos2._x ; x++ )
			tipList.setPosKind(new Position(x, pos1._y), Tip.KIND_NON);
	}

	/**
	 * 始点と終点を繋げる Y方向
	 */
	private function linePassY():Void{

		for( var y:Number=pos1._y ; y <= pos2._y ; y++ )
			tipList.setPosKind(new Position(pos1._x, y), Tip.KIND_NON);
	}

	/**
	 * 必須接続位置記憶
	 *
	 * @return 必須接続位置二箇所設定された/true or false
	 */
	private function recordPassPos( pos:Position ):Boolean{

		if( npos1 == null ) npos1 = pos; else npos2 = pos;
		return npos2 != null;
	}
}
