﻿import game.automap.Position;
import game.automap.Couple;
import game.automap.RectList;
import game.automap.Room;

/**
 * 区画
 * 
 * @author dango-itimi
 */
class game.automap.Rect {

	private var pos   :Position; //左上マップ位置
	private var width :Number;   //マップ横範囲
	private var height:Number;   //マップ縦範囲

	//この区画を区分けする方向
	public static var COLS:Number = 1;
	public static var ROWS:Number = 2;
	private var vec:Number;
	
	//隣接する分割線一覧 : 最大四本
	//存在しない場合 undefined が挿入される
	// 1 : 上
	// 2 : 下
	// 3 : 左
	// 4 : 右
	private var clist:/*Couple*/Array;
	
	//この区画内に存在する区画
	private var rect1 :Rect   = null;
	private var rect2 :Rect   = null;
	private var couple:Couple = null; //この区画を分ける分割線
	
	//この区画内に存在する部屋
	private var room:Room = null;

	//getter
	public function get _width ():Number  { return width;  }
	public function get _height():Number  { return height; }
	public function get _pos   ():Position{ return pos;    }
	public function get _vec   ():Number  { return vec;    }
	public function get _rect1 ():Rect    { return rect1;  }
	public function get _rect2 ():Rect    { return rect2;  }
	public function get _couple():Couple  { return couple; }
	public function get _clist ():Array   { return clist;  }
	public function get _room  ():Room    { return room;   }
	
	/**
	 * コンストラクタ
	 */
	public function Rect( pos:Position, width:Number, height:Number, 
						  vec:Number, clist:/*Couple*/Array ){
						  	
		this.pos     = pos;
		this.width   = width;
		this.height  = height;
		this.vec     = vec;
		this.clist   = clist;
	}

	/**
	 * 区画分け
	 *
	 * @return 区画分け実行/true or 区画分けできず
	 */
	public function cut():Boolean{

		//各区画分け幅取得
		var n:Number  = (vec == COLS) ? width : height;
		var n1:Number = Math.floor( Math.random() * n );
		var n2:Number = n - (n1 + 1);

		//最小サイズより小さい場合
		if( n1 < RectList.MIN || n2 < RectList.MIN ) return false;

		//縦分け/横分け
		if(vec == COLS) cutCols(n1, n2); else cutRows(n1, n2);
		return true;
	}

	/**
	 * 区画 縦分け
	 */
	private function cutCols(n1:Number, n2:Number):Void{

		//分割線作成
		this.couple = new Couple(
			new Position(pos._x + n1, pos._y),
			new Position(pos._x + n1, pos._y + height)
		);

		//区画に隣接する分割線一覧作成
		var cplList1:/*Couple*/Array = [];
		var cplList2:/*Couple*/Array = [];

		cplList1[0] = clist[0];
		cplList1[1] = clist[1];
		cplList1[2] = clist[2];
		cplList1[3] = couple;

		cplList2[0] = clist[0];
		cplList2[1] = clist[1];
		cplList2[2] = couple;
		cplList2[3] = clist[3];
	
		//区画作成
		var p :Position = new Position(pos._x + n1 + 1, pos._y);
		this.rect1 = new Rect(pos, n1, height, ROWS, cplList1);
		this.rect2 = new Rect(p,   n2, height, ROWS, cplList2);
	}

	/**
	 * 区画 横分け
	 */
	private function cutRows(n1:Number, n2:Number):Void{

		//分割線作成
		this.couple = new Couple(
			new Position(pos._x,         pos._y + n1),
			new Position(pos._x + width, pos._y + n1)
		);

		//区画に隣接する分割線一覧作成
		var cplList1:/*Couple*/Array = [];
		var cplList2:/*Couple*/Array = [];

		cplList1[0] = clist[0];
		cplList1[1] = couple;
		cplList1[2] = clist[2];
		cplList1[3] = clist[3];

		cplList2[0] = couple;
		cplList2[1] = clist[1];
		cplList2[2] = clist[2]; 
		cplList2[3] = clist[3];

		//区画作成
		var p:Position = new Position(pos._x, pos._y + n1 + 1);
		this.rect1 = new Rect(pos, width, n1, COLS, cplList1);
		this.rect2 = new Rect(p,   width, n2, COLS, cplList2);
	}
	
	/**
	 * この区画内に部屋作成
	 */
	public function createRoom():Void{
		
		this.room = new Room(this);
	}
	
	/**
	 * この区画内にある二つの区画内の部屋を通路で繋げる
	 */
	public function setPass():Void{
		
		var rm:Room;
		rm = rect1.getMinRoom(couple);
		rm.setPass(couple);
		
		rm = rect2.getMinRoom(couple);
		rm.setPass(couple);
	}
	
	/**
	 * 指定分割線に接している最小部屋取得
	 */
	private function getMinRoom(cpl:Couple):Room{
		
		//この区画が分割されていない場合
		if(couple == null) return (checkCouple(cpl)) ? room : null;
		
		//この区画内の区画1,2を調査
		var rm:Room = rect1.getMinRoom(cpl);
		return (rm != null) ? rm : rect2.getMinRoom(cpl);
	}
	
	/**
	 * 指定分割線に接しているかどうか調査
	 */
	private function checkCouple(cpl:Couple):Boolean{
		
		for(var i:Number=0; i < clist.length ; i++){
			if(cpl === clist[i]) return true;
		}
		return false;
	}
}

