﻿import game.automap.AutoMap;
import game.automap.Rect;
import game.automap.Position;

/**
 * 区画一覧
 * 
 * @author dango-itimi
 */
class game.automap.RectList {

	public static var MIN:Number; //最低区画サイズ

	private var list:/*Rect*/Array;

	//getter
	public function get _list():Array{ return this.list; }

	//Singleton
	private static var instance:RectList = new RectList();
	public  static function get _instance():RectList{ return instance; }
	private function RectList(){}

	/**
	 * 初期化
	 */
	public function init():Void{

		RectList.MIN = AutoMap.RS + 2; //最低区画サイズ設定
		this.list = new Array();
	}

	/**
	 * 区画生成
	 */
	public function create():Void{

		//全体区画作成
		var rect:Rect = 
			new Rect( new Position(0, 0), AutoMap.MX, AutoMap.MY, Rect.COLS );

		//全体区画 区画分け
		roop(rect, true);
	}

	/**
	 * 区画生成再帰処理
	 *
	 * @param flg 全体区画分けである/true or false
	 */
	private function roop( rect:Rect, flg:Boolean ):Void{
		
		//区画分け
		if( rect.cut() ){

			//分けた区画を更に区画分け
			roop( rect._rect1, false );
			roop( rect._rect2, false );
		}
		//全体区画分けで区画分けされなかった場合 : 再度分割を試みる
		else if(flg){ roop(rect, true); return; }

		//区画分けされなかった場合 : 区画内に部屋作成
		else rect.createRoom();
			
		list.push(rect);
	}
	
	/**
	 * 区画内の部屋に必須通路を繋げる
	 */
	public function setPass():Void{
		
		for( var i:Number=0; i < list.length ; i++ ) Rect(list[i]).setPass();
	}
	
	/**
	 * 各部屋にランダム通路を作成
	 */
}
