﻿import game.automap.Rect;
import game.automap.Position;
import game.automap.AutoMap;
import game.automap.Couple;
import game.automap.TipList;
import game.automap.Tip;

/**
 * 部屋
 * 
 * @author dango-itimi
 */
class game.automap.Room {

	private var pos   :Position; //左上マップ位置
	private var width :Number;   //マップ横範囲
	private var height:Number;   //マップ縦範囲
	
	private var R_INTER:Number = 1; //区切り線から離す隙間量
	private var W_INTER:Number = 1; //通路作成時の壁から離す隙間量
	
	/**
	 * コンストラクタ
	 * 
	 * @param rect この部屋が属する区画
	 */
	public function Room(rect:Rect){

		//左上マップ位置 ランダム決定
		setPos(rect);
		
		//横幅/縦幅決定
		this.width  = (rect._pos._x + rect._width  - R_INTER) - pos._x;
		this.height = (rect._pos._y + rect._height - R_INTER) - pos._y;

		//部屋チップ設定
		var tipList:TipList = TipList._instance;
		for( var y:Number=pos._y; y < pos._y + height ; y++ ){
		for( var x:Number=pos._x; x < pos._x + width  ; x++ ){
			
			tipList.setPosKind(new Position(x, y), Tip.KIND_NON);
		}
		}
	}
	
	/**
	 * 部屋 左上マップ位置設定
	 */
	private function setPos(rect:Rect):Void{
		
		var tx:Number = ran(rect._width  - AutoMap.RS - R_INTER) + rect._pos._x;
		var ty:Number = ran(rect._height - AutoMap.RS - R_INTER) + rect._pos._y;
		
		//壁が区切り線に隣接してしまっている場合 : 位置調整
		if(tx == rect._pos._x) tx += R_INTER;
		if(ty == rect._pos._y) ty += R_INTER;
		
		this.pos = new Position(tx, ty);
	}

	/**
	 * 必須通路作成
	 * 
	 * @param cpl この部屋に通路を繋げるための分割線
	 */
	public function setPass(cpl:Couple):Void{

		cpl.setPass( getPassPos(cpl) );
	}

	/**
	 * 分割線に向かって通路を出す壁位置取得
	 * 壁両端には通路は出さない
	 */
	private function getPassPos( cpl:Couple ):Position{

		if( cpl._kind == Couple.KIND_COLS ){
			
			var r:Number = ran(height - W_INTER) + pos._y;
			if(r == pos._y) r += W_INTER;
			
			//分割線が部屋の左/右側にある場合
			return (cpl._pos1._x < pos._x) ? new Position(pos._x - 1, r) : 
											 new Position(pos._x + width, r);
		}else{
			
			var r:Number = ran(width - W_INTER) + pos._x;
			if(r == pos._x) r += W_INTER;
			
			//分割線が部屋の上/下側にある場合
			return (cpl._pos1._y < pos._y) ? new Position(r, pos._y - 1) : 
											 new Position(r, pos._y + height);
		}
	}

	/**
	 * ランダム通路作成
	 */
	public function setRandomPass():Void{

	}
	
	/**
	 * ランダム変数取得
	 */
	private function ran(n:Number):Number{ 
		return Math.floor(Math.random() * n);
	}
}
