﻿import game.automap.AutoMap;
import game.automap.Position;
import game.automap.Tip;

/**
 * マップチップ一覧
 * 
 * @author dango-itimi
 */
class game.automap.TipList {

	private var list:/*Array*/Array;
	
	//Singleton
	private static var instance:TipList = new TipList();
	public  static function get _instance():TipList{ return instance; }
	private function TipList(){}

	/**
	 * 初期化
	 */
	public function init():Void{

		//全て障害物でマップを埋める
		this.list = [];
		for( var y:Number=0; y < AutoMap.MY ; y++ ){
			
			list[y] = [];
			for( var x:Number=0 ; x < AutoMap.MX ; x++ ){

				list[y][x] = new Tip(x, y, Tip.KIND_BACK);
			}
		}
	}
	
	/**
	 * 指定位置のチップ取得
	 */
	public function getTip( x:Number, y:Number ):Tip{
		
		return list[y][x];
	}

	/**
	 * 指定位置のチップ種別を設定
	 *
	 * @param pos 指定位置
	 * @param kind 変更種別
	 */
	public function setPosKind( pos:Position, kind:Number ):Void{

		Tip( list[pos._y][pos._x] )._kind = kind;
	}
	
	/**
	 * マップtrace
	 */
	public function traceMap():Void{
		
		var str:String = "";
		for( var y:Number=0; y < AutoMap.MY ; y++, str+="\n" ){
		for( var x:Number=0; x < AutoMap.MX ; x++ ){
			
			var kind:Number = Tip(list[y][x])._kind;
			str += ( kind == Tip.KIND_NON  ) ? "■" : 
				   ( kind == Tip.KIND_BACK ) ? "□" : "☆";
		}
		}
		trace(str);
	}
}
