﻿import effect.text.pop.Text;

/**
 * 文字一覧
 */
class effect.text.pop.List {
	
	private var list:/*Text*/Array;
	
	private var INTER:Number = 0; //各文字登場間隔フレーム数
	private var disp :Number = 0; //表示開始済み文字ID
	private var cnt  :Number = 0;
		
	/**
	 * コンストラクタ
	 */
	public function List(mc:MovieClip, str:String, fclr:Number, bclr:Number){
		
		var len:Number = str.length;
		this.list = [];
		
		//各文字ＭＣ生成
		for (var i:Number = 0; i < len; i++)
			list.push(new Text(mc, i, str.charAt(i), fclr, bclr));
			
		//位置調整
		for (var i:Number=0, x:Number=0; i < len; i++){
			
			var txt:Text = list[i];
			txt._x = x;
			x = txt._right + 1;
		}
		mc._x -= Math.floor(mc._width / 2);
	}

	/**
	 * 破棄処理
	 */
	public function destroy():Void{

		for (var i:Number=0 ; i < list.length; i++) Text(list[i]).destroy();
		
	}

	/**
	 * メインフレーム
	 * 
	 * @return 最後の文字まで表示終了/true or false
	 */
	public function frame():Boolean{
		
		var len:Number  = list.length;
		var flg:Boolean = false;	
		for(var i:Number = 0; i < len; i++){

			if(i > disp) break;

			var c:Boolean = Text(list[i]).frame();
			if(i == len-1 && c) flg = true;
		}
		if(++cnt > INTER){ cnt = 0; disp++; }
		return flg;
	}
}
