﻿import effect.text.pop.List;

/**
 * ビットマップ ドットテキスト ポップアップ
 */
class effect.text.pop.Pop {
	
	private var mc  :MovieClip;
	private var str :String;
	private var list:List;
	private var main:Function = null;
	
	private var MC_NAME:String = "textMC";
	
	/**
	 * コンストラクタ
	 * 
	 * @param scene テキスト表示レイヤー
	 * @param x     表示位置x座標
	 * @param y     表示位置y座標
	 * @param str   表示対象文字列
	 * @param fclr  文字の淵の色 16進数文字コード
	 * @param bclr  文字ベース色 16進数文字コード
	 */
	public function Pop(scene:MovieClip, x:Number, y:Number, str:String, fclr:Number, bclr:Number) {
		
		var id:Number = scene.getNextHighestDepth();
		this.mc    = scene.createEmptyMovieClip(MC_NAME + id, id);
		this.mc._x = x;
		this.mc._y = y;
		
		this.str  = str;
		this.list = new List(mc, str, fclr, bclr); 
	}
	
	/**
	 * メインフレーム
	 * 
	 * @return 表示処理終了/true or 表示処理中/false
	 */
	public function frame():Boolean{
		
		if(main == null) start();
		main();	
		return main == null;
	}
	
	/**
	 * 破棄処理
	 */
	public function destroy():Void{
		
		list.destroy();
		this.mc.removeMovieClip();
	}
	
	/**
	 * 初期処理
	 */
	private function start():Void{
		
		main = disp;
	}
	
	/**
	 * 表示
	 */
	private function disp():Void{
		
		if(!list.frame()) return;
		
		this.mc.removeMovieClip();
		main = null;
	}
}