﻿/**
 * 各文字
 */
class effect.text.pop.Text{
	
	private var mc     :MovieClip;
	private var frontMC:MovieClip;
	private var backMC :MovieClip;
	
	private var MC_NAME :String = "mc";
	private var FRONT_ID:String = "frontMC";
	private var BACK_ID :String = "backMC";

	private var main:Function = null;
	
	//動作
	private var FIRST_SPEED:Number = 4;
	private var TOP_SPEED  :Number = 1;
	private var UP_PER     :Number = 0.7;
	private var DOWN_PER   :Number = 1.3;
	private var speed      :Number = FIRST_SPEED;
	
	//動作終了後の待機フレーム数
	private var WAIT_COUNT:Number = 20;
	private var wcnt:Number = 0;

	public function set _x(x:Number):Void{ this.mc._x = x; }
	public function get _width():Number{ return mc._width; }
	public function get _right():Number{ return mc._x + _width; }
	
	/**
	 * コンストラクタ
	 * 
	 * @param fclr 淵の色
	 * @param bclr ベース色
	 */
	public function Text(scene:MovieClip, id:Number, str:String, fclr:Number, bclr:Number){

		this.mc      = scene.createEmptyMovieClip(MC_NAME + id, id);
		this.backMC  = mc.attachMovie(BACK_ID,  BACK_ID,  0);
		this.frontMC = mc.attachMovie(FRONT_ID, FRONT_ID, 1);
		
		//文字設定
		var n:Number = str.charCodeAt(0);
		this.backMC.gotoAndStop(n);
		this.frontMC.gotoAndStop(n);
		
		//文字色設定
		var fc:Color = new Color(frontMC);	
		var bc:Color = new Color(backMC);	
		fc.setRGB(fclr);
		bc.setRGB(bclr);

		mc._visible = false;
	}

	/**
	 * 破棄処理
	 */
	public function destroy():Void{
		
		this.backMC.removeMovieClip();
		this.frontMC.removeMovieClip();
		this.mc.removeMovieClip();
	}

	/**
	 * メインフレーム
	 */
	public function frame():Boolean{

		if(main == null) start();
		main();
		return main == null;
	}

	/**
	 * 初期処理
	 */
	private function start():Void{

		mc._visible = true;
		main = up;
	}

	/**
	 * 文字上昇
	 */
	private function up():Void{

		mc._y -= speed;
		speed *= UP_PER;
		if(speed < TOP_SPEED) main = down;
	}

	/**
	 * 文字下降
	 */
	private function down():Void{

		mc._y += speed;
		speed *= DOWN_PER;
		if(mc._y < 0) return;
		
		mc._y = 0;
		main = wait;
	}
	
	/**
	 * 動作終了後の待機
	 */
	private function wait():Void{
		
		if(++wcnt < WAIT_COUNT) return;
		
		this.mc.removeMovieClip();
		main = null;
	}
}

