function Main(){

	this.init.apply(this, arguments);
}
Main.prototype.init = function(flashFileURL, swfNames, serverTotal){

	this.doc = fl.openDocument(flashFileURL);
	this.profileXML = this.doc.exportPublishProfileString();

	this.profileXMLReplacer = new ProfileXMLReplacer();
	this.carrierActionScript = new CarrierActionScript(this.doc);

	this.profileXML = this.profileXMLReplacer.replace(
		this.profileXML, "defaultNames", "0"
	);
	this.profileXML = this.profileXMLReplacer.replace(
		this.profileXML, "flashDefaultName", "0"
	);

	for(var i=0; i < swfNames.length; i++){

		var swfName = swfNames[i];
		for(var j=0; j < serverTotal; j++){

			this.carrierActionScript["action" + i](j);
			this.publish(swfName + j);
		}
	}
};
Main.prototype.publish = function(swfName){

	this.profileXML = this.profileXMLReplacer.replace(
		this.profileXML, "flashFileName", swfName + ".swf"
	);
	this.doc.importPublishProfileString(this.profileXML);
	this.doc.publish();
};

